/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.rjmx.services.flr.internal.AbstractConverter;
import com.jrockit.mc.rjmx.services.flr.internal.BooleanConverter;
import com.jrockit.mc.rjmx.services.flr.internal.Converter;
import com.jrockit.mc.rjmx.services.flr.internal.StringConverter;

public class BasicPrimitivesConverter {
    public static <T extends Comparable<T>> Converter<T> getConverter(Class<T> type) {
        if (Double.class.equals(type)) {
            return new DoubleConverter();
        }
        if (Long.class.equals(type)) {
            return new LongConverter();
        }
        if (String.class.equals(type)) {
            return new StringConverter();
        }
        if (Integer.class.equals(type)) {
            return new IntegerConverter();
        }
        if (Boolean.class.equals(type)) {
            return new BooleanConverter();
        }
        return null;
    }

    public static final class DoubleConverter
    extends AbstractConverter<Double> {
        @Override
        public Class<Double> getType() {
            return Double.class;
        }

        @Override
        public Double toServerValue(String configString) {
            return Double.valueOf(configString);
        }
    }

    public static final class IntegerConverter
    extends AbstractConverter<Integer> {
        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public Integer toServerValue(String configString) {
            return Integer.valueOf(configString);
        }
    }

    public static final class LongConverter
    extends AbstractConverter<Long> {
        @Override
        public Class<Long> getType() {
            return Long.class;
        }

        @Override
        public Long toServerValue(String configString) {
            return Long.valueOf(configString);
        }
    }
}

